//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	HILDA Wealth Import and Cleaning
// Objective: 	Calculating aggregate and mean wealth from the HILDA dataset.
//				Presenting the data in both current and 2020 prices.
//
// Created: 	12/04/2021
// Modified: 	15/11/2021
//==============================================================================

***************************************
*** Importing and cleaning the Data ***
***************************************

clear

cd "XXXX" // set the content directory here

use HILDA_restricted_combined 													// opening the data

g year = wave + 2000 															// generating a year variable

drop if year == 2001
drop if year >= 2003 & year <= 2005
drop if year >= 2007 & year <= 2009
drop if year >= 2011 & year <= 2013
drop if year >= 2015 & year <= 2017
drop if year == 2019								 							// dropping years for which wealth data is unavailable

**************************************
*** Weighting the wealth variables ***
**************************************

g net_worth = pwassei - pwdebti 												// generating a net worth variable

local wealth_vars pwobani pwjbani pwsupri pwsupwi pwoccdi pwjccdi pwhecdi pwothdi pwhmvai pwhmdti pwopvai pwopdti pwcbani pwcaini pweqini pwbusvi pwbusdi pwtrusi pwinsui pwcolli pwvechi pwobdti pwtbani pwsupei pwtpvi pwccdti pwtpdi pwfini pwnfii pwassei pwdebti net_worth 																	  // creating a local macro containing all wealth variables

foreach w in `wealth_vars' {
	g wt_`w' = `w' * hhwte 														// weighting the data using the population level enumerated person weights
} 																				// should not in this instance matter whether you use the household or enumerated person weights as it is being summed later

collapse(sum) pwobani pwjbani pwsupri pwsupwi pwoccdi pwjccdi pwhecdi pwothdi pwhmvai pwhmdti pwopvai pwopdti pwcbani pwcaini pweqini pwbusvi pwbusdi pwtrusi pwinsui pwcolli pwvechi pwobdti pwtbani pwsupei pwtpvi pwccdti pwtpdi pwfini pwnfii pwassei pwdebti net_worth wt_pwobani wt_pwjbani wt_pwsupri wt_pwsupwi wt_pwoccdi wt_pwjccdi wt_pwhecdi wt_pwothdi wt_pwhmvai wt_pwhmdti wt_pwopvai wt_pwopdti wt_pwcbani wt_pwcaini wt_pweqini wt_pwbusvi wt_pwbusdi wt_pwtrusi wt_pwinsui wt_pwcolli wt_pwvechi wt_pwobdti wt_pwtbani wt_pwsupei wt_pwtpvi wt_pwccdti wt_pwtpdi wt_pwfini wt_pwnfii wt_pwassei wt_pwdebti wt_net_worth, by(year) // collapsing (summing) the data by year

save "HILDA Aggregate Wealth Current", replace 									// saving the dataset